#include <Array.au3>
#include <HtmlSelector.au3>

;Init only XPath selector
If Not _HTMLSelector_Init($HSEL_INIT_XPATHSEL) Then
	MsgBox(16, 'Error', 'Unable to initialize HtmlSelector' & @CRLF & @CRLF & 'OK ==> EXIT')
	Exit
EndIf

_Example1()
_Example2()

Func _Example1()
	Local $sHTML, $sXPath, $sSelect
	
	$sHTML = BinaryToString(InetRead('http://autoitscript.com'), 4)
	$sXPath = '//div[@id="featured-area"]/div[@class="container clearfix"]/div[@id="featured-slider"]/div[@class="featitem clearfix"][1]/div[@class="excerpt"]/p'
	$sSelect = _HtmlSelector_SelectByXPath($sHTML, $sXPath, 1, $HSEL_RSLT_INNERTEXT)
	
	Switch @error
		Case 0
			MsgBox(64, 'Result', $sSelect)
		Case 1
			MsgBox(48, 'Error - ' & $sXPath, 'Unable to initialize HtmlAgilityPack.HtmlDocument object (check Framework version, 2 or 4).')
			Exit
		Case 2
			MsgBox(48, 'Error - ' & $sXPath, 'Nodes not found.')
		Case 3
			MsgBox(48, 'Error - ' & $sXPath, 'Selected nodes count = 0.')
	EndSwitch
EndFunc

Func _Example2()
	Local $sHTML, $aXPaths, $aSelect, $fLoadHtml = True
	
	$sHTML = _
		'<html>' & @CRLF & _
		'	<body>' & @CRLF & _
		'		<span id="users" class="users">' & @CRLF & _
		'			<div id="user">User1</div>' & @CRLF & _
		'			<div id="user" class="user">User2</div>' & @CRLF & _
		'			<div id="user" class="user">User3</div>' & @CRLF & _
		'		</span>' & @CRLF & _
		'		<span id="logins" class="logins">' & @CRLF & _
		'			<div id="login">login1</div>' & @CRLF & _
		'			<div id=login>login2</div>' & @CRLF & _
		'			<div id=login>login3</div>' & @CRLF & _
		'		</span>' & @CRLF & _
		'	</body>' & @CRLF & _
		'</html>' & @CRLF
	
	Dim $aXPaths[2] = _
		[ _
			'html/body/span/div[(@id="user" and @class="user")]', _ 					;User2, User3
			'/*/body/span[@id="logins" or @class="logins"][1]/div[@id="login"][2]' _ 	;login2
		]
	
	For $i = 0 To 1
		$aSelect = _HtmlSelector_SelectByXPath($sHTML, $aXPaths[$i], -1, -1, $fLoadHtml)
		
		Switch @error
			Case 0
				_ArrayDisplay($aSelect, $aXPaths[$i])
				
				;Display first node attributes
				$sType = $aSelect[1][$HSEL_RSLT_TYPE] & ' of Node #1'
				$aAttribs = $aSelect[1][$HSEL_RSLT_ATTRIBS]
				
				_ArrayDisplay($aAttribs, $sType & ' Attributes')
			Case 1
				MsgBox(48, 'Error - ' & $aXPaths[$i], 'Unable to initialize HtmlAgilityPack.HtmlDocument object (check Framework version - 2 or 4).')
				Exit
			Case 2
				MsgBox(48, 'Error - ' & $aXPaths[$i], 'Nodes not found.')
			Case 3
				MsgBox(48, 'Error - ' & $aXPaths[$i], 'Selected nodes count = 0.')
		EndSwitch
		
		$fLoadHtml = False
	Next
EndFunc
